#!/usr/bin/python2
# Autor: Frane Kurtovic

def parse_term(term):
    term = term.strip()
    term_parts = term.split('x')
    assert len(term_parts) <= 2, \
           'Parsiranje terma {} nije uspjelo'.format(term)
    k, power = 1, 1
    for part in term_parts:
        if len(part) == 0:
            continue
        if part[0] == '^':
            power = int(part[1:])
        else:
            k = int(part)
    return (k, power)

def parse(poli):
    terms = poli.split('+')
    ret = [parse_term(term) for term in terms]
    return ret

def add(da, db):
    print 'add d{} d{}'.format(da, db)

def mul(da, db):
    print 'mul d{} d{}'.format(da, db)

# Uvijek d0=x
# Uvijek d1=0
# U d2 napravim x^power od kojeg radim potencije broja 2
# U d3 napravim k*x^power
# U d4 dodaje rezultat
def calc_term(k, power):
    mul(2, 1)
    mul(3, 1)

    add(2, 0)
    for _ in xrange(power-1):
        mul(2, 0)
    for pot in xrange(10):
        if k&(1<<pot):
            add(3, 2)
        if (1<<(pot+1))-1 >= k:
            break
        add(2, 2)
    add(4, 3) # Krajnji polinom

def main():
    import sys
    poli_str = sys.stdin.readline().strip()
    for term_k, term_pow in parse(poli_str):
        calc_term(term_k, term_pow)

    mul(0, 1)
    add(0, 4)


if __name__ == "__main__":
    main()
